/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;

public class DecimalLocaleConverter
extends BaseLocaleConverter {
    private DecimalFormat formatter;

    public DecimalLocaleConverter() {
        this(false);
    }

    public DecimalLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public DecimalLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public DecimalLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public DecimalLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public DecimalLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public DecimalLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public DecimalLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
        this.formatter = (DecimalFormat)DecimalFormat.getInstance(this.locale);
    }

    public DecimalLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public DecimalLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    protected Object parse(Object value, String pattern) throws ParseException {
        if (this.locPattern) {
            this.formatter.applyLocalizedPattern(pattern);
        } else {
            this.formatter.applyPattern(pattern);
        }
        return this.formatter.parse((String)value);
    }

    public DecimalLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    public DecimalLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue, locale, pattern, locPattern);
        this.formatter = (DecimalFormat)DecimalFormat.getInstance(this.locale);
    }
}

